//
//  PITItem.m
//  PIT
//
//  Created by VA DEVELOPER on 11/24/12.
//  Copyright (c) 2012. All rights reserved.
//

#import "PITItem.h"
#import "PITAppDelegate.h"

@implementation PITItem

@synthesize containedItem, 
            container, 
            dateCreated, // The date record was created
            itemFirstName, // The first name
            itemMiddleName, // The middle name
            itemLastName, // The last name
            itemAge, // The numeric age
            itemGender, // The letter M|F for gender
            itemChronic, // Boolean for Chronically homeless
            itemFreeLocation, // Free text for location details
            itemCity, // Free text for city
            itemState, // Free text for date
            itemLatitude, // Current latitude
            itemLongitude, // Current longitude
            itemAccuracy, // Level of accuracy of coordinates
//            imageKey; // Image key that allows images, if used.
            itemID; //GUID record ID used to locate records in central DB

- (void)encodeWithCoder:(NSCoder *)aCoder
{
    [aCoder encodeObject:itemFirstName forKey:@"itemFirstName"];
    [aCoder encodeObject:itemMiddleName forKey:@"itemMiddleName"];
    [aCoder encodeObject:itemLastName forKey:@"itemLastName"];
    [aCoder encodeInt:itemAge forKey:@"itemAge"];
    [aCoder encodeObject:itemGender forKey:@"itemGender"];
    [aCoder encodeBool:itemChronic forKey:@"itemChronic"];
    [aCoder encodeObject:itemFreeLocation forKey:@"itemFreeLocation"];
    [aCoder encodeObject:itemCity forKey:@"itemCity"];
    [aCoder encodeObject:itemState forKey:@"itemState"];
    [aCoder encodeDouble:itemLatitude forKey:@"itemLatitude"];
    [aCoder encodeDouble:itemLongitude forKey:@"itemLongitude"];
    [aCoder encodeDouble:itemAccuracy forKey:@"itemAccuracy"];
    [aCoder encodeObject:dateCreated forKey:@"dateCreated"];
    [aCoder encodeObject:itemID forKey:@"itemID"];
    
}

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];
    if (self) {
        [self setItemFirstName:[aDecoder decodeObjectForKey:@"itemFirstName"]];
        [self setItemMiddleName:[aDecoder decodeObjectForKey:@"itemMiddleName"]];
        [self setItemLastName:[aDecoder decodeObjectForKey:@"itemLastName"]];
        [self setItemAge:[aDecoder decodeIntForKey:@"itemAge"]];
        [self setItemGender:[aDecoder decodeObjectForKey:@"itemGender"]];
        [self setItemChronic:[aDecoder decodeBoolForKey:@"itemChronic"]];
        [self setItemFreeLocation:[aDecoder decodeObjectForKey:@"itemFreeLocation"]];
        [self setItemCity:[aDecoder decodeObjectForKey:@"itemCity"]];
        [self setItemState:[aDecoder decodeObjectForKey:@"itemState"]];
        [self setItemLatitude:[aDecoder decodeDoubleForKey:@"itemLatitude"]];
        [self setItemLongitude:[aDecoder decodeDoubleForKey:@"itemLongitude"]];
        [self setItemAccuracy:[aDecoder decodeDoubleForKey:@"itemAccuracy"]];
        dateCreated = [aDecoder decodeObjectForKey:@"dateCreated"];
        [self setItemID:[aDecoder decodeObjectForKey:@"itemID"]];
    }
    return self;
}

- (id) init {
    return [self initItem];
}

- (NSString *) description {
    NSString *descriptionString =
    [[NSString alloc] initWithFormat:@"%@ %@ %@", itemFirstName, itemMiddleName, itemLastName];
    
    return descriptionString;
}


- (id) initItem {
    self = [super init];
    
    if (self) {
        // We start with these default to make
        // sure that we match the default segmented controls.
        [self setItemFirstName: @""];
        [self setItemMiddleName: @""];
        [self setItemLastName: @""];
        
        [self setItemGender: @"M"];
        [self setItemChronic: FALSE];
        dateCreated = [[NSDate alloc] init];
        [self setItemID:[PITAppDelegate CreateUUID]];
    }
    
    return self;
} 

+ (id) initWithItemLocation:(NSString *) sLocation
        itemCity:(NSString *) sCity
          itemState:(NSString *) sState
{
    PITItem *newItem = [[self alloc] initItem];
    
    [newItem setItemFreeLocation: sLocation];
    [newItem setItemCity: sCity];
    [newItem setItemState: sState];
    
    
    return newItem;
}

+ (id) newItem {
    PITItem *newItem = [[self alloc] initItem];
    
    return newItem;
}


- (void) setContainedItem: (PITItem *) i {
    containedItem = i;
    [i setContainer:self];
}




/*

-(void) dealloc {
    NSLog(@"Destroyed: %@", self);
}
*/

/*
#pragma mark Temporary Functions

+ (id) randomItem {
    NSArray *randomTitleList = [NSArray arrayWithObjects:
                                @"",
                                nil];
    
    NSArray *randomDetailList = [NSArray arrayWithObjects:
                                 @"",
                                 nil];
    
    NSInteger titleIndex = rand() % [randomTitleList count];
    NSInteger detailIndex = rand() % [randomDetailList count];
    
    NSString *randomTitle = [NSString stringWithFormat:@"%@",
                            [randomTitleList objectAtIndex:titleIndex]];

    NSString *randomDetail = [NSString stringWithFormat:@"%@",
                             [randomDetailList objectAtIndex:detailIndex]];

    PITItem *newItem = [[self alloc] initWithItemTitle:randomTitle itemDetail:randomDetail];
    
    return newItem;
}
*/


@end
